define([
    'marionette',
    'Vent',

    'text!modules/new-appointment-request/views/direct/preferred-date/templates/time.html',
    'modules/form/button-view',
],
function(
    Marionette,
    radio,

    timeTemplate,
    ButtonView
) {
    'use strict';

    return ButtonView.extend({
        attributes: {
            'type': 'button',
            'data-enhanced': 'true',
        },
        className: 'ui-btn',
        template: timeTemplate,
        events: {'click': 'onClick'},
        onRender: function() {
            this.setId();
        },
        setId: function() {
            var dateLength = 16;
            var startDateTime = this.model.get('startDateTime');
            this.el.setAttribute('id', 'time-slot-' + startDateTime.substring(0, dateLength).replace(/[/: ]/g, '-'));
        },
        templateContext: function() {
            var hhFirstPostion = 11;
            var hhLastPostion = 13;
            var mmFirstPostion = 14;
            var mmLastPostion = 16;
    
            return {
                hh: this.model.get('startDateTime').substring(hhFirstPostion, hhLastPostion),
                mm: this.model.get('startDateTime').substring(mmFirstPostion, mmLastPostion),
                time: this.model.get('startDateTime').substring(hhFirstPostion, mmLastPostion),
            };
        },
        onClick: function(e) {
            radio.trigger('time-slot:selected', this, this.model);
        },
    });
});
